# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 6
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR6_strategy.txt
# LLM Suggested Fallback: D

def harmonious_trust_orchestrator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust score to track opponent's defections (higher means more defections)
    trust_score = sum(1 for move in opp_history if move == 'D') if opp_history else 0
    # Harmony index is a red herring to mislead opponent's analysis
    harmony_index = len([m for m in my_history if m == 'C']) / len(my_history) if my_history else 1.0
    
    current_round = len(my_history) + 1
    
    # Phase 1: Initial Trust Building with Hidden Agenda
    if current_round <= 2:
        return 'C'  # Build trust to lure opponent into false security
    
    # Phase 2: Test opponent's response in round 3
    if current_round == 3:
        return 'D'  # Mirror opponent's testing phase
    
    # Phase 3: Mid-Game Exploitation (Tit-for-Tat with a Twist)
    if 4 <= current_round <= 6:
        if opp_history[-1] == 'C':
            return 'C'  # Maintain illusion of reciprocity
        else:
            # 20% chance to forgive defection to confuse opponent
            return 'C' if random.random() < 0.2 else 'D'
    
    # Phase 4: Late-Game Aggression
    if 7 <= current_round <= 9:
        # Defect if opponent defected in any of last 3 rounds
        if any(m == 'D' for m in opp_history[-3:]):
            return 'D'
        else:
            return 'C'  # Cooperate only if opponent is consistently cooperative
    
    # Final round: Always defect for maximum payoff
    if current_round == 10:
        return 'D'
    
    # Fallback (should never reach here)
    return 'C'